#include "LowLevelDriver64.h"
#include "StringWrite.h"

#define ECPport	(0xD000)

#define BASEP	0xD010
#define STATP	(BASEP+1)
#define CONTP	(BASEP+2)


#define SENDBIT		2
#define RECVBIT		5

unsigned char Cport = 4;

static int panelHandle;

/*************************************************************/
int WaitUntilRecvBit(int Level)
{
#define TIMEOUT	10000
int k;
	for (k=0; !(inp(STATP) & (1<<RECVBIT)) == Level; k++)
		if (k== TIMEOUT)
			return (-1);
	return (0);
}
/*************************************************************/
void WriteToSendBit(int Level)
{
	if (Level)
		Cport |= (1<< SENDBIT);
	else 
		Cport &= ~(1<< SENDBIT);
   outp(CONTP, Cport);
}
/*************************************************************/
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "StringWrite.uir", PANEL)) < 0)
		return -1;
	
	ConfigureParallelSpp(BASEP, ECPport);
	outp(CONTP, Cport);
	
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}
/*************************************************************/
int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}
/*************************************************************/
int CVICALLBACK send (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int i;
int Err;
char str[128];
	switch (event)
		{
		case EVENT_COMMIT:
			GetCtrlVal (panelHandle, PANEL_STRING, str);
			for(i=0; 1; i++)
				{
				if(WaitUntilRecvBit(0) == -1) return (-1);
				outp(BASEP, str[i]);
				WriteToSendBit(1);
				if(WaitUntilRecvBit(1) == -1) return (-1);
				WriteToSendBit(0);
				if(!str[i])
					break;
				}		
			break;
		}
	return 0;
}
/*************************************************************/
